<x-app-layout>
    <x-slot name="header">
        Package
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route($role.'.package.create') }}" class="btn btn-primary">Add New </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Package</th>
                                    <th class="border-bottom-0">Category</th>
                                    <th class="border-bottom-0">Destination</th>
                                    <th class="border-bottom-0">Start Date</th>
                                    <th class="border-bottom-0">Start & End</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($packages as $package)
                                <tr>
                                    <td>
                                        <div class="d-flex">
                                            @isset($package->thumbnail)
                                            <div class="avatar-md me-3">
                                                <img src="{{ asset($package->thumbnail) }}"
                                                class="rounded-4" alt="image">
                                            </div>
                                            @endisset
                                            <p>{{ $package->name }}</p>
                                        </div>
                                    </td>
                                    <td>{{ $package->category->name }}</td>
                                    <td>{{ $package->destination->name }}</td>
                                    <td>{{ $package->start_date?->format('D F, Y') }}</td>
                                    <td>
                                        {{ $package->start_point }} - {{ $package->end_point }}
                                    </td>
                                    <td>
                                        @if ($package->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                        @if ($package->published)
                                        <span class="badge bg-info">Published</span>
                                        @endif
                                        @if ($package->featured)
                                        <span class="badge bg-primary">Featured</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route($role.'.package.edit', $package->id) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route($role.'.package.destroy', $package->id) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
